/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class OriginArgument
implements ArgumentType<Origin> {
    public static final DynamicCommandExceptionType ORIGIN_NOT_FOUND = new DynamicCommandExceptionType(p_208663_0_ -> new TranslationTextComponent("commands.origin.origin_not_found", new Object[]{p_208663_0_}));

    public static OriginArgument origin() {
        return new OriginArgument();
    }

    public Origin parse(StringReader p_parse_1_) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.func_195826_a((StringReader)p_parse_1_);
        try {
            return OriginRegistry.get(id);
        }
        catch (IllegalArgumentException e) {
            throw ORIGIN_NOT_FOUND.create((Object)id);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        OriginLayer layer = null;
        try {
            layer = (OriginLayer)context.getArgument("layer", OriginLayer.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (layer != null) {
            LinkedList<ResourceLocation> ids = new LinkedList<ResourceLocation>(layer.getOrigins());
            ids.add(Origin.EMPTY.getIdentifier());
            return ISuggestionProvider.func_212476_a(ids.stream(), (SuggestionsBuilder)builder);
        }
        return ISuggestionProvider.func_212476_a(OriginRegistry.identifiers(), (SuggestionsBuilder)builder);
    }
}

